package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

/**
 * StageReminder entity.
 * 
 */

public class StageAdmissionsAndDischarges extends StageEntity {

	// Fields
	private Date admissionDate;
	private String admissionDateImprecise;
	private String admittingSpeciality;
	private String admittingPhysician;
	private Date dischargeDate;
	private String dischargeDateImprecise;
	private String dischargePhysician;
	private String dischargeSummary;
	private String visitEncounterId;
	// Constructors

	public Date getAdmissionDate() {
		return admissionDate;
	}

	public void setAdmissionDate(Date admissionDate) {
		this.admissionDate = admissionDate;
	}

	public String getAdmittingSpeciality() {
		return admittingSpeciality;
	}

	public void setAdmittingSpeciality(String admittingSpeciality) {
		this.admittingSpeciality = admittingSpeciality;
	}

	public String getAdmittingPhysician() {
		return admittingPhysician;
	}

	public void setAdmittingPhysician(String admittingPhysician) {
		this.admittingPhysician = admittingPhysician;
	}

	public Date getDischargeDate() {
		return dischargeDate;
	}

	public void setDischargeDate(Date dischargeDate) {
		this.dischargeDate = dischargeDate;
	}

	public String getDischargePhysician() {
		return dischargePhysician;
	}

	public void setDischargePhysician(String dischargePhysician) {
		this.dischargePhysician = dischargePhysician;
	}

	public String getDischargeSummary() {
		return dischargeSummary;
	}

	public void setDischargeSummary(String dischargeSummary) {
		this.dischargeSummary = dischargeSummary;
	}

	public String getVisitEncounterId() {
		return visitEncounterId;
	}

	public void setVisitEncounterId(String visitEncounterId) {
		this.visitEncounterId = visitEncounterId;
	}

	/**
	 * default constructor do not provide auto initialization since this class
	 * can be used in findByExample
	 */
	public StageAdmissionsAndDischarges() {
		super();
	}

	// Property accessors
	
	public String toString() {
		return  "StageAdmissionsAndDischarges {" + 
				", id=" + getId() + 
				", oplock=" + oplock +
				", createdDate=" + createdDate + 
				", modifiedDate=" + modifiedDate + 
				", icn='" + icn + '\'' +
				", stationNumber='"	+ stationNumber + '\'' + 
				", requestMsgCtrlId=" + requestMsgCtrlId + 
				", responseMsgCtrlId=" + responseMsgCtrlId + 
				", extractStatus='" + extractStatus + '\'' + 
				", recordStatus='" + recordStatus + '\'' + 
				", admissionsDate=" + admissionDate + 
				", admittingSpeciality='" + admittingSpeciality + '\'' +
				", admittingPhysician='" + admittingPhysician + '\'' +
				", dischargePhysician='" + dischargePhysician + '\'' +
				", dischargeDate='" + dischargeDate + '\'' +
				", dischargeSummary='" + dischargeSummary + '\'' +
				", visitEncounterId='" + visitEncounterId + '\'' +
				'}';
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		result = String.valueOf(obj).equalsIgnoreCase(String.valueOf(this));
		return result;
	}

	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of immunization.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}

	public void setDischargeDateImprecise(String dischargeDateImprecise) {
		this.dischargeDateImprecise = dischargeDateImprecise;
	}

	public String getDischargeDateImprecise() {
		return dischargeDateImprecise;
	}

	public void setAdmissionDateImprecise(String admissionDateImprecise) {
		this.admissionDateImprecise = admissionDateImprecise;
	}

	public String getAdmissionDateImprecise() {
		return admissionDateImprecise;
	}
	
	public String toCompare() {
		return ""+
		getAdmissionDate()+
		getAdmittingPhysician()+
		getAdmittingSpeciality()+
		getDischargeDate()+
		getDischargePhysician()+
		getDischargeSummary()+
		getVisitEncounterId();
	}
	
}
